/*:ja
 * @target MZ
 * @plugindesc CoF用の小さな変更
 * @author 柊　七紀
 * @help
 * 他作品への無断使用はお控えください。
 * 個人の範囲で改変する分には問題ありません。
 *
 * 
 *
 */

(() => {

    //-----------------------------------------------------------------------------
    // ●　衣装の名前を代入
    //-----------------------------------------------------------------------------

    const VARIABLE_ID = 5; // 名前を格納する変数ID (例: 10番)
    const ACTOR_ID = 1;     // 対象のアクターID (1番)
    const SLOT_ID = 2;      // 対象の装備スロットID (3番)

    // Game_Actor.prototype.changeEquip に処理を割り込ませる
    const _Game_Actor_changeEquip = Game_Actor.prototype.changeEquip;
    Game_Actor.prototype.changeEquip = function(slotId, item) {
        // まずオリジナルの装備変更処理を実行
        _Game_Actor_changeEquip.apply(this, arguments);
        // 変更後の処理 -----------------------------------------
        // 1. 対象のアクターIDとスロットIDが一致するかチェック
        if (this.actorId() === ACTOR_ID && slotId === SLOT_ID) {
            
            // 2. 装備品の名前を取得
            // 装備アイテムは this.equips()[slotId] で取得
            const equipItem = this.equips()[slotId]; 
            
            // 3. 変数に入れる名前を決定
            const itemName = equipItem ? equipItem.name : "裸";
            
            // 4. ゲーム変数に代入
            $gameVariables.setValue(VARIABLE_ID, itemName);
            
        }
        // ------------------------------------------------------
    };


    //=============================================================================
    // ●　装備画面のステータス表示拡張（HP/MPの追加）
    //=============================================================================
    
    Window_EquipStatus.prototype.drawAllParams = function() {
        // 0:HP, 1:MP, 2:攻撃 ... 7:運
        for (let i = 0; i < 8; i++) {
            const x = this.itemPadding();
            const y = this.lineHeight() * (i + 1);
            this.drawItem(x, y, i);
        }
    };

    
})();